/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.jira.core;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.IOUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.jetty.util.epl.ajax.JSON;
import com.aptana.jira.core.JiraCorePlugin;
import com.aptana.jira.core.JiraException;
import com.aptana.jira.core.JiraIssue;
import com.aptana.jira.core.JiraIssueConfig;
import com.aptana.jira.core.JiraIssueType;
import com.aptana.jira.core.JiraUser;
import com.aptana.jira.core.Messages;
import com.aptana.jira.core.internal.JiraProjectsRegistry;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.eclipse.core.internal.preferences.Base64;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JiraManager {
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String USER_AGENT = "User-Agent";
    private static final String ACCEPT_HEADER = "Accept";
    private static final String ACCEPT_CONTENT_TYPES = "application/json";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String SECURE_PREF_NODE = "com.aptana.jira.core";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    static final String APTANA_STUDIO = "APSTUD";
    static final String TITANIUM_COMMUNITY = "AC";
    private static final String PARAM_ENVIRONMENT = "environment";
    private static final String PARAM_VERSION = "versions";
    private static final String LABELS = "labels";
    private static String projectName = "Aptana Studio";
    private static String projectKey = "APSTUD";
    private static final String HOST_NAME = "jira.appcelerator.org";
    private static final String HOST_URL = "https://jira.appcelerator.org";
    private static final String REST_API_ENDPOINT = "https://jira.appcelerator.org/rest/api/2/";
    private JiraUser user;

    JiraManager() {
        this.loadCredentials();
        this.loadProjectInfo();
    }

    private void loadProjectInfo() {
        JiraProjectsRegistry projectsRegistry = this.getJiraProjectsRegistry();
        JiraProjectsRegistry.JiraProjectInfo projectProvider = projectsRegistry.getProjectInfo();
        if (projectProvider != null) {
            JiraManager.setProjectInfo(projectProvider.getProjectName(), projectProvider.getProjectCode());
        }
    }

    protected JiraProjectsRegistry getJiraProjectsRegistry() {
        return new JiraProjectsRegistry();
    }

    public JiraUser getUser() {
        return this.user;
    }

    public IStatus login(String username, String password) {
        HttpURLConnection connection = null;
        try {
            connection = this.createConnection(this.getUserURL(username), username, password);
            int code = connection.getResponseCode();
            if (code == 200) {
                this.user = new JiraUser(username, password);
                this.saveCredentials();
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            if (code == 401 || code == 403) {
                Status status = new Status(4, SECURE_PREF_NODE, code, Messages.JiraManager_BadCredentialsErrMsg, null);
                return status;
            }
            String msg = IOUtil.read((InputStream)connection.getInputStream());
            Status status = new Status(4, SECURE_PREF_NODE, code, String.valueOf(Messages.JiraManager_UnknownErrMsg) + ": " + msg, null);
            return status;
        }
        catch (Exception e) {
            Status status = new Status(4, SECURE_PREF_NODE, e.getMessage(), (Throwable)e);
            return status;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    protected String getUserURL(String username) throws UnsupportedEncodingException {
        return "https://jira.appcelerator.org/rest/api/2/user?username=" + URLEncoder.encode(username, "UTF-8");
    }

    protected HttpURLConnection createConnection(String urlString, String username, String password) throws MalformedURLException, IOException {
        URL url = new URL(urlString);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty(USER_AGENT, this.getProjectVersion());
        connection.setRequestProperty(ACCEPT_HEADER, ACCEPT_CONTENT_TYPES);
        connection.setRequestProperty(CONTENT_TYPE, ACCEPT_CONTENT_TYPES);
        connection.setUseCaches(false);
        connection.setAllowUserInteraction(false);
        String usernamePassword = String.valueOf(username) + ":" + password;
        connection.setRequestProperty(AUTHORIZATION_HEADER, "Basic " + new String(Base64.encode((byte[])usernamePassword.getBytes())));
        return connection;
    }

    public void logout() {
        ISecurePreferences prefs = this.getSecurePreferences();
        try {
            prefs.remove(USERNAME);
            prefs.remove(PASSWORD);
            prefs.flush();
            this.user = null;
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)JiraCorePlugin.getDefault(), (String)"Failed to log out Jira user", (Throwable)e);
        }
    }

    public JiraIssue createIssue(JiraIssueConfig jiraConfig) throws JiraException, IOException {
        if (this.user == null) {
            throw new JiraException(Messages.JiraManager_ERR_NotLoggedIn);
        }
        HttpURLConnection connection = null;
        try {
            connection = this.createConnection(this.getCreateIssueURL(), this.user.getUsername(), this.user.getPassword());
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            String severityJSON = TITANIUM_COMMUNITY.equals(projectKey) && jiraConfig.type == JiraIssueType.IMPROVEMENT || !TITANIUM_COMMUNITY.equals(projectKey) && jiraConfig.type != JiraIssueType.BUG ? "" : String.valueOf(jiraConfig.severity.getParameterValue()) + ",\n";
            String projectVersion = this.getProjectVersion();
            String versionString = this.isProjectVersionExists(projectVersion) ? "\"versions\": [{\"name\": \"" + projectVersion + "\"}]" : MessageFormat.format("\"{0}\": \"{1}\"", PARAM_ENVIRONMENT, projectVersion);
            String labels = "\"labels\": [\"" + jiraConfig.label + "\"]";
            String data = "{\n    \"fields\": {\n       \"project\":\n       { \n          \"key\": \"" + projectKey + "\"\n" + "       },\n" + "       \"summary\": \"" + jiraConfig.summary.replaceAll("\"", "'") + "\",\n" + "       \"description\": \"" + jiraConfig.description.replaceAll("\"", "'").replaceAll("\n", Matcher.quoteReplacement("\\n")) + "\",\n" + "       \"issuetype\": {\n" + "          \"name\": \"" + jiraConfig.type.getParameterValue(projectKey) + "\"\n" + "       },\n" + severityJSON + "       " + versionString + "\n," + "       " + labels + "\n" + "   }\n" + "}";
            OutputStream out = connection.getOutputStream();
            IOUtil.write((OutputStream)out, (String)data);
            out.close();
            int responseCode = connection.getResponseCode();
            if (responseCode == 200 || responseCode == 201) {
                String output = IOUtil.read((InputStream)connection.getInputStream());
                JiraIssue jiraIssue = this.createIssueFromJSON(output);
                return jiraIssue;
            }
            try {
                throw new JiraException(IOUtil.read((InputStream)connection.getErrorStream()));
            }
            catch (JiraException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JiraException(e.getMessage(), e);
            }
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    protected boolean isProjectVersionExists(String projectVersion) {
        try {
            return this.getProjectVersions().contains(projectVersion);
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)JiraCorePlugin.getDefault(), (Throwable)e);
            return false;
        }
    }

    protected List<String> getProjectVersions() throws JiraException {
        ArrayList<String> projectNames = new ArrayList<String>();
        HttpURLConnection connection = null;
        try {
            connection = this.createConnection(this.getProjectVersionsURL(), this.user.getUsername(), this.user.getPassword());
            connection.setRequestMethod("GET");
            int responseCode = connection.getResponseCode();
            if (responseCode == 200 || responseCode == 201) {
                Object[] parse;
                String output = IOUtil.read((InputStream)connection.getInputStream());
                Object[] objectArray = parse = (Object[])JSON.parse((String)output);
                int n = parse.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    if (object instanceof Map) {
                        Map projectEntry = (Map)object;
                        projectNames.add((String)projectEntry.get("name"));
                    }
                    ++n2;
                }
                ArrayList<String> arrayList = projectNames;
                return arrayList;
            }
            try {
                throw new JiraException(IOUtil.read((InputStream)connection.getErrorStream()));
            }
            catch (JiraException je) {
                throw je;
            }
            catch (Exception e) {
                throw new JiraException(e.getMessage(), e);
            }
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    protected String getProjectVersionsURL() {
        return "https://jira.appcelerator.org/rest/api/2/project/" + projectKey + "/versions";
    }

    protected JiraIssue createIssueFromJSON(String output) {
        Map map = (Map)JSON.parse((String)output);
        String issueKey = (String)map.get("key");
        String issueId = (String)map.get("id");
        String issueUrl = "https://jira.appcelerator.org/browse/" + issueKey;
        return new JiraIssue(issueKey, issueId, issueUrl);
    }

    protected String getCreateIssueURL() {
        return "https://jira.appcelerator.org/rest/api/2/issue";
    }

    public void addAttachment(IPath path, JiraIssue issue) throws JiraException {
        if (path == null || issue == null) {
            return;
        }
        if (this.user == null) {
            throw new JiraException(Messages.JiraManager_ERR_NotLoggedIn);
        }
        AbstractHttpClient httpclient = this.createClient();
        BasicAuthCache authCache = new BasicAuthCache();
        BasicScheme basicAuth = new BasicScheme();
        HttpHost targetHost = new HttpHost(HOST_NAME, 443, "https");
        authCache.put(targetHost, (AuthScheme)basicAuth);
        BasicHttpContext localcontext = new BasicHttpContext();
        localcontext.setAttribute("http.auth.auth-cache", (Object)authCache);
        HttpPost filePost = null;
        try {
            try {
                filePost = new HttpPost(this.createAttachmentURL(issue));
                File file = path.toFile();
                MultipartEntity reqEntity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
                reqEntity.addPart("file", (ContentBody)new FileBody(file));
                filePost.setEntity((HttpEntity)reqEntity);
                filePost.addHeader((Header)new BasicHeader("X-Atlassian-Token", "nocheck"));
                HttpResponse response = this.post(httpclient, targetHost, filePost, localcontext);
                StatusLine sl = response.getStatusLine();
                int responseCode = sl.getStatusCode();
                HttpEntity respEntity = response.getEntity();
                InputStream in = respEntity.getContent();
                if (responseCode != 200 && responseCode != 201) {
                    throw new JiraException(IOUtil.read((InputStream)in));
                }
                String json = IOUtil.read((InputStream)in);
                IdeLog.logInfo((Plugin)JiraCorePlugin.getDefault(), (String)json);
            }
            catch (JiraException e) {
                throw e;
            }
            catch (Exception e) {
                throw new JiraException(e.getMessage(), e);
            }
        }
        finally {
            this.closeConnection(httpclient);
        }
    }

    protected void closeConnection(AbstractHttpClient httpclient) {
        if (httpclient == null) {
            return;
        }
        httpclient.getConnectionManager().shutdown();
    }

    protected HttpResponse post(AbstractHttpClient httpclient, HttpHost targetHost, HttpPost filePost, BasicHttpContext localcontext) throws ClientProtocolException, IOException {
        return httpclient.execute(targetHost, (HttpRequest)filePost, (HttpContext)localcontext);
    }

    protected AbstractHttpClient createClient() {
        DefaultHttpClient httpclient = new DefaultHttpClient();
        UsernamePasswordCredentials creds = new UsernamePasswordCredentials(this.user.getUsername(), this.user.getPassword());
        httpclient.getCredentialsProvider().setCredentials(new AuthScope(HOST_NAME, 443), (Credentials)creds);
        httpclient.getParams().setBooleanParameter("http.protocol.handle-authentication", true);
        return httpclient;
    }

    protected String createAttachmentURL(JiraIssue issue) {
        return "https://jira.appcelerator.org/rest/api/2/issue/" + issue.getName() + "/attachments";
    }

    public static void setProjectInfo(String projectName, String projectKey) {
        if (!StringUtil.isEmpty((String)projectName)) {
            JiraManager.projectName = projectName;
        }
        if (!StringUtil.isEmpty((String)projectKey)) {
            JiraManager.projectKey = projectKey;
        }
    }

    private void loadCredentials() {
        ISecurePreferences prefs = this.getSecurePreferences();
        try {
            String username = prefs.get(USERNAME, null);
            String password = prefs.get(PASSWORD, null);
            if (!StringUtil.isEmpty((String)username) && !StringUtil.isEmpty((String)password)) {
                this.user = new JiraUser(username, password);
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)JiraCorePlugin.getDefault(), (String)"Failed to load Jira user credentials", (Throwable)e);
        }
    }

    private void saveCredentials() {
        ISecurePreferences prefs = this.getSecurePreferences();
        try {
            prefs.put(USERNAME, this.user.getUsername(), true);
            prefs.put(PASSWORD, this.user.getPassword(), true);
            prefs.flush();
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)JiraCorePlugin.getDefault(), (String)"Failed to save Jira user credentials", (Throwable)e);
        }
    }

    protected String getProjectVersion() {
        String versionStr = EclipseUtil.getStudioVersion();
        Version version = new Version(versionStr);
        return MessageFormat.format("{0} {1}.{2}.{3}", projectName, version.getMajor(), version.getMinor(), version.getMicro());
    }

    protected ISecurePreferences getSecurePreferences() {
        return SecurePreferencesFactory.getDefault().node(SECURE_PREF_NODE);
    }
}

